#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N, K;
    cin >> N >> K;

    vector<int> lokacijeProdavnica(K);
    vector<int> populacija(N);

    for (int i = 0; i < K; ++i) {
        cin >> lokacijeProdavnica[i];
    }

    for (int i = 0; i < N; ++i) {
        cin >> populacija[i];
    }

    vector<bool> pokriven(N, false);
    int brojProdavnica = 0;

    vector<pair<int, int>> gradovi;
    for (int i = 0; i < N; ++i) {
        gradovi.push_back({populacija[i], i});
    }
    sort(gradovi.rbegin(), gradovi.rend());

    for (auto grad : gradovi) {
        int gradID = grad.second + 1;
        if (!pokriven[grad.second]) {
            if (find(lokacijeProdavnica.begin(), lokacijeProdavnica.end(), gradID) == lokacijeProdavnica.end()) {
                ++brojProdavnica;
                pokriven[grad.second] = true;
                if (grad.second > 0) pokriven[grad.second - 1] = true;
                if (grad.second < N - 1) pokriven[grad.second + 1] = true;
            }
        }
    }

    cout << brojProdavnica << endl;

    return 0;
}